#!/bin/sh

###############################################################
#   This script should be hooked when invoking SYNOShareSet()
#   Usable environment variable:
#       ORIGIN_SHARE_NAME, SHARE_NAME, ORIGIN_SHARE_PATH, SHARE_PATH,
#       ORIGIN_SHARE_STATUS, SHARE_STATUS
#
#   Note: The script should bear to be invoked multiple times 
###############################################################

#Include common scripts
FILE_SYSLOGNG_INC_SCRP=/usr/libexec/SyslogShareCommon.sh
. ${FILE_SYSLOGNG_INC_SCRP}

#At begining, acquire package settings
PackageInfoGet;

LocationChangeCheck(){
    # Only hooked when share name or share path changed
    if [ "${ORIGIN_SHARE_NAME}" != "${SHARE_NAME}" ] || [ "${ORIGIN_SHARE_PATH}" != "${SHARE_PATH}" ] || 
       [ "${ORIGIN_SHARE_STATUS}" = "decrypt" -a "${SHARE_STATUS}" = "normal" ] ||
       [ "${ORIGIN_SHARE_STATUS}" = "normal" -a "${SHARE_STATUS}" = "decrypt" ]; then
        NEED_HOOK=1;
    else
        NEED_HOOK=0;
    fi
}

case $1 in
    --sdk-mod-ver)
        #Print SDK support version
        echo ${SYSLOGNG_PKG_MODVER};
    ;;
    --name)
        #Print package name
        echo ${SYSLOGNG_PKG_NAME};
    ;;
    --pkg-ver)
        #Print package version
        echo ${SYSLOGNG_PKG_VERSION};
    ;;
    --vendor)
        #Print package vendor
        echo ${SYSLOGNG_PKG_VENDOR};
    ;;
    --pre)
        #Actions before share set

        ################################################
        # PS: Service is paused by service framework
        ################################################
    ;;
    --post)
        #Actions after share set

        #Check if service share
        ServiceInfoGet;
        CHK_SHARE=${ORIGIN_SHARE_NAME};
        SvrShareCheck;
        if [ "1" != "${IS_SVR_SHARE}" ]; then
            return;
        fi

        #Check hook condition
        LocationChangeCheck;
        if [ "1" != "${NEED_HOOK}" ]; then 
            return;
        fi

        #Check action success or not
        if [ "0" = "${RESULT}" ]; then
            SyslogServiceLocSet;
            SyslogMailShareRename;
            #Restart service syslog-acc to reload config
            SyslogServiceDisable ${KEY_SERVICE_ACC}
            SyslogServiceEnable ${KEY_SERVICE_ACC}
        fi

        ################################################
        # PS: Service is resumed/disabled by service framework
        ################################################
    ;;
    *)
        echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
    ;;
esac

